%%%% STAGE1, ExcelToStructure %%%%
%%%% Converts .xlsx files to .MAT data for input to subsequent scripts

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Benny Guralnik, 2014 benny.guralnik@gmail.com %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clearvars -except filename filenamevec NITL NITLvec SAR_model SAR_MODEL nSAR

ka = 1e3.*365.*24.*3600; 

[exist,sheets] = xlsfinfo([filename '.xlsx']);

for i=1:length(sheets) 
	[~,~,raw] = xlsread([filename '.xlsx'],i,'A1:N30'); 
    raw(~cellfun(@isfloat,raw)) = {NaN}; 

    records(i).rawdata(1).Ddot= raw{2,8};
	records(i).id = sheets{i};
	lastrow = length(raw);
	firstrow = 7;   

	for k=firstrow:3:lastrow
		j = (k-firstrow)/3+1;
		records(i).rawdata(j).T = raw{k,2};
		records(i).rawdata(j).Ddot = raw{k+1,2};
		records(i).rawdata(j).t = [raw{k,4:end}];
		records(i).rawdata(j).L = [raw{k+1,4:end}];
        records(i).rawdata(j).Lerror = [raw{k+2,4:end}];
    end
end
save(['./ComputeData/' filename '.mat'],'records') 
